use master

go

if exists (select name from sys.objects where name like 'TK_MAN_STATS') drop procedure TK_MAN_STATS

go

create procedure TK_MAN_STATS @BASE varchar(100),@DIF_MIN INT,@DUPD_STATS INT,@VNULL varchar(2)

as

begin

if exists (select name from tempdb.sys.objects where name like '##stats_table')drop table ##stats_table

 

set nocount on

DECLARE @TABLE_NAME VARCHAR(100),

@STATS_NAME VARCHAR(100),

@COMANDO NVARCHAR(500),

@HORA_INICIO DATETIME,

@DATABASE_ID INT,

@LAST_UPD DATETIME,

@DATABASE_NAME VARCHAR(200)

--@MED_FRAG INT,

--@DUPD_STATS INT,

--@DIF_MIN INT

 

-- Definindo janela de manuteno

select @HORA_INICIO= GETDATE()

-- Define comprimento da janela.

--select @DIF_MIN=4

--select @DUPD_STATS =50

 

-------------------------------- Manuteno pata todas as bases de dados ------------------------

IF @BASE LIKE 'TODAS'

  BEGIN

 

DECLARE man_cursor CURSOR FOR

SELECT database_id,

        '[' + name + ']'

FROM   sys.databases

WHERE name <> 'MASTER'

        AND name <> 'MODEL'

        AND name <> 'MSDB'

        AND name NOT LIKE'REPORTSERVER%'

        AND name <> 'TEMPDB'

ORDER BY name

 

OPEN man_cursor;

 

FETCH next FROM man_cursor INTO @DATABASE_ID, @DATABASE_NAME

 

WHILE @@FETCH_STATUS = 0

BEGIN

-------------------------------- Incio do tratamento de estatsticas --------------------

 

set @COMANDO=null

if @VNULL = 's'

begin

select @comando = 'select  ''[''+obj.name+'']'' TableName,''[''+stat.name+'']'' as StatName,STATS_DATE(obj.OBJECT_ID, stat.stats_id) AS LastUpdate

into ##stats_table

from '+@database_name+'.sys.stats stat inner join '+@DATABASE_NAME+'.sys.objects obj on stat.object_id=obj.object_id

where obj.type=''u''

order by LastUpdate asc'

EXEC SP_EXECUTESQL @COMANDO

end

else

begin

select @comando = 'select  ''[''+obj.name+'']'' TableName,''[''+stat.name+'']'' as StatName,STATS_DATE(obj.OBJECT_ID, stat.stats_id) AS LastUpdate

into ##stats_table

from '+@database_name+'.sys.stats stat inner join '+@DATABASE_NAME+'.sys.objects obj on stat.object_id=obj.object_id

where obj.type=''u''

and STATS_DATE(obj.OBJECT_ID, stat.stats_id) is not NULL

order by LastUpdate asc'

EXEC SP_EXECUTESQL @COMANDO

end

--select * from ##STATS_TABLE

 

 

DECLARE MAN_STATS CURSOR FOR

SELECT TABLENAME,STATNAME,LastUpdate FROM ##STATS_TABLE WHERE DATEDIFF(DAY,LASTUPDATE,GETDATE()) >= @DUPD_STATS

 

OPEN MAN_STATS

 

FETCH NEXT FROM MAN_STATS INTO @TABLE_NAME,@STATS_NAME,@Last_Upd

 

WHILE @@FETCH_STATUS = 0

BEGIN

 -- Controle de execuo da rotina em horrio prprio

 IF DATEDIFF(MINUTE,@HORA_INICIO,GETDATE()) <= @DIF_MIN

 BEGIN

         begin try

                 SET @COMANDO =NULL

                 select @COMANDO = 'UPDATE STATISTICS '+@DATABASE_NAME+'..'+@TABLE_NAME+'('+@STATS_NAME+')'

                 EXEC SP_EXECUTESQL @COMANDO

                 INSERT INTO MASTER..TK_STAT_HIST VALUES (@DATABASE_NAME,@TABLE_NAME,@STATS_NAME,@Last_Upd,GETDATE())

         end try

      begin catch

                 SELECT

                 ERROR_NUMBER() AS ErrorNumber,

                 ERROR_MESSAGE() AS ErrorMessage;

      end catch

 END

FETCH NEXT FROM MAN_STATS INTO @TABLE_NAME,@STATS_NAME,@Last_Upd

END

 

CLOSE MAN_STATS

DEALLOCATE MAN_STATS

DROP TABLE ##stats_table

 

FETCH NEXT FROM man_cursor INTO @DATABASE_ID, @DATABASE_NAME

END

 

CLOSE man_cursor

DEALLOCATE man_cursor

 

set nocount off

-- End fim da procedure

end

 

-- Fim do IF para @BASE='TODAS'

 

 

-- Manuteno em base de dados especfica.

IF @base <> 'TODAS'

  BEGIN

      SET @DATABASE_NAME='['+@base+']'

        IF EXISTS (SELECT Lower(+name)

                  FROM   sys.databases

                  WHERE name LIKE @base)

        BEGIN

        --select @DATABASE_NAME AS 'DATABASE'

     

DECLARE man_cursor CURSOR FOR

SELECT database_id,

        '[' + name + ']'

FROM   sys.databases

WHERE name like @BASE

 

OPEN man_cursor;

 

FETCH next FROM man_cursor INTO @DATABASE_ID, @DATABASE_NAME

 

WHILE @@FETCH_STATUS = 0

BEGIN

-------------------------------- Incio do tratamento de estatsticas --------------------

 

set @COMANDO=null

if @VNULL = 's'

begin

select @comando = 'select  ''[''+obj.name+'']'' TableName,''[''+stat.name+'']'' as StatName,STATS_DATE(obj.OBJECT_ID, stat.stats_id) AS LastUpdate

into ##stats_table

from '+@database_name+'.sys.stats stat inner join '+@DATABASE_NAME+'.sys.objects obj on stat.object_id=obj.object_id

where obj.type=''u''

order by LastUpdate asc'

EXEC SP_EXECUTESQL @COMANDO

end

else

begin

select @comando = 'select  ''[''+obj.name+'']'' TableName,''[''+stat.name+'']'' as StatName,STATS_DATE(obj.OBJECT_ID, stat.stats_id) AS LastUpdate

into ##stats_table

from '+@database_name+'.sys.stats stat inner join '+@DATABASE_NAME+'.sys.objects obj on stat.object_id=obj.object_id

where obj.type=''u''

and STATS_DATE(obj.OBJECT_ID, stat.stats_id) is not NULL

order by LastUpdate asc'

EXEC SP_EXECUTESQL @COMANDO

end

--select * from ##STATS_TABLE

 

 

DECLARE MAN_STATS CURSOR FOR

SELECT TABLENAME,STATNAME,LastUpdate FROM ##STATS_TABLE WHERE DATEDIFF(DAY,LASTUPDATE,GETDATE()) >= @DUPD_STATS OR (LASTUPDATE is NULL AND @VNULL = 's')

 

OPEN MAN_STATS

 

FETCH NEXT FROM MAN_STATS INTO @TABLE_NAME,@STATS_NAME,@Last_Upd

 

WHILE @@FETCH_STATUS = 0

BEGIN

 -- Controle de execuo da rotina em horrio prprio

 IF DATEDIFF(MINUTE,@HORA_INICIO,GETDATE()) <= @DIF_MIN

 BEGIN

         begin try

                 SET @COMANDO =NULL

                 select @COMANDO = 'UPDATE STATISTICS '+@DATABASE_NAME+'..'+@TABLE_NAME+'('+@STATS_NAME+')'

                 EXEC SP_EXECUTESQL @COMANDO

                 INSERT INTO MASTER..TK_STAT_HIST VALUES (@DATABASE_NAME,@TABLE_NAME,@STATS_NAME,@Last_Upd,GETDATE())

         end try

      begin catch

                 SELECT

                 ERROR_NUMBER() AS ErrorNumber,

                 ERROR_MESSAGE() AS ErrorMessage;

      end catch

 END

FETCH NEXT FROM MAN_STATS INTO @TABLE_NAME,@STATS_NAME,@Last_Upd

END

 

CLOSE MAN_STATS

DEALLOCATE MAN_STATS

DROP TABLE ##stats_table

 

FETCH NEXT FROM man_cursor INTO @DATABASE_ID, @DATABASE_NAME

END

 

CLOSE man_cursor

DEALLOCATE man_cursor

 

set nocount off

 

end

 

ELSE

        BEGIN

            PRINT 'Base de dados ou opo no existe !

Use @base=''todas'' para manuteno em todas as bases de dados ou @base=''nomebase'' para uma base especfica.'

        END

-- Fim da

end

-- End fim da procedure

end